
/**
 * Every colour with its related name and symbol
 */
export const mcColorCodes = {
  "§0": "§0Black",
  "§1": "§1Dark Blue",
  "§2": "§2Dark Green",
  "§3": "§3Dark Aqua",
  "§4": "§4Dark Red",
  "§5": "§5Dark Purple",
  "§6": "§6Gold",
  "§7": "§7Gray",
  "§8": "§8Dark Gray",
  "§9": "§9Blue",
  "§a": "§aGreen",
  "§b": "§bAqua",
  "§c": "§cRed",
  "§d": "§dLight Purple",
  "§e": "§eYellow",
  "§f": "§fWhite",
  "§m": "§mRedstone",
  "§n": "§nCopper",
};

export function getColourCodeFromName(name) {
    for (const [code, colourName] of Object.entries(mcColorCodes)) {
        if (colourName.toLowerCase() === name.toLowerCase()) {
            return code;
        }
    }
    return "§f"; // Default to white
}

/**
 * Every fomats with its related name and symbol
 */
export const mcFormattingCodes = {
    "": "None",
    "§k": "Obfuscated(§kObf§r)",
    "§l": "§lBold",
    "§o": "§oItalic",
    "§r": "§rReset"
};

export function getFormatCodeFromName(name) {
    for (const [code, formatName] of Object.entries(mcFormattingCodes)) {
        if (formatName.toLowerCase() === name.toLowerCase()) {
            return code;
        }
    }
    return ""; // Default to no formats
}

export const GameModeDD = [
    "Survival",
    "Creative",
    "Spectator",
    "Adventure"
];

export const DimensionDD = [
    "Overworld",
    "Nether",
    "The End"
];
